<?php
/**
 * @package     Joomla.Site
 * @subpackage  Layout
 *
 * @copyright   Copyright (C) 2005 - 2020 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

include_once(__DIR__ . '../../settings_content.php');

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;

$params    = $displayData['params'];
$item      = $displayData['item'];
$direction = Factory::getLanguage()->isRtl() ? 'left' : 'right';

$readmorelinkclass = TCK_LAYOUT_CONTENT_READMORE_LINK_CLASS;
$readmoreicon = (TCK_LAYOUT_CONTENT_READMORE_SHOW_ICON == 1 ? '<span class="' . TCK_LAYOUT_CONTENT_READMORE_ICON . ' ' . $direction . '" aria-hidden="true"></span>' : '');
?>

<p class="readmore tck-readmore">
	<?php if (!$params->get('access-view')) : ?>
		<a class="btn btn-secondary <?php echo $readmorelinkclass ?>" href="<?php echo $displayData['link']; ?>" aria-label="<?php echo Text::_('JGLOBAL_REGISTER_TO_READ_MORE') . ' ' . $this->escape($item->title); ?>">
			<?php echo $readmoreicon; ?>
			<?php echo Text::_('JGLOBAL_REGISTER_TO_READ_MORE'); ?>
		</a>
	<?php elseif ($readmore = $item->alternative_readmore) : ?>
		<a class="btn btn-secondary <?php echo $readmorelinkclass ?>" href="<?php echo $displayData['link']; ?>" aria-label="<?php echo $this->escape($readmore . ' ' . $item->title); ?>">
			<?php echo $readmoreicon; ?>
			<?php echo $readmore; ?>
			<?php if ($params->get('show_readmore_title', 0) != 0) : ?>
				<?php echo HTMLHelper::_('string.truncate', $item->title, $params->get('readmore_limit')); ?>
			<?php endif; ?>
		</a>
	<?php elseif ($params->get('show_readmore_title', 0) == 0) : ?>
		<a class="btn btn-secondary <?php echo $readmorelinkclass ?>" href="<?php echo $displayData['link']; ?>" aria-label="<?php echo Text::sprintf('JGLOBAL_READ_MORE_TITLE', $this->escape($item->title)); ?>">
			<?php echo $readmoreicon; ?>
			<?php echo Text::_('JGLOBAL_READ_MORE'); ?>
		</a>
	<?php else : ?>
		<a class="btn btn-secondary <?php echo $readmorelinkclass ?>" href="<?php echo $displayData['link']; ?>" aria-label="<?php echo Text::sprintf('JGLOBAL_READ_MORE_TITLE', $this->escape($item->title)); ?>">
			<?php echo $readmoreicon; ?>
			<?php echo Text::sprintf('JGLOBAL_READ_MORE_TITLE', HTMLHelper::_('string.truncate', $item->title, $params->get('readmore_limit'))); ?>
		</a>
	<?php endif; ?>
</p>
